<style>
    .btn-circle {
        width: 30px;
        height: 30px;
        text-align: center;
        padding: 6px 0;
        font-size: 12px;
        line-height: 1.428571429;
        border-radius: 15px;
    }

    .btn-circle.btn-lg {
        width: 30px;
        height: 30px;
        padding: 10px 10px;
        font-size: 18px;
        line-height: 1.5;
        border-radius: 25px;
    }

    .btn-circle.btn-xl {
        width: 70px;
        height: 70px;
        padding: 10px 16px;
        font-size: 24px;
        line-height: 1.33;
        border-radius: 35px;
    }

    .cd-panel {
        position: fixed;
        top: 0;
        left: 0;
        height: 100%;
        width: 100%;
        visibility: hidden;
        -webkit-transition: visibility 0s 0.6s;
        -moz-transition: visibility 0s 0.6s;
        transition: visibility 0s 0.6s;
    }

    .cd-panel::after {
        /* overlay layer */
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: transparent;
        cursor: pointer;
        -webkit-transition: background 0.3s 0.3s;
        -moz-transition: background 0.3s 0.3s;
        transition: background 0.3s 0.3s;
    }

    .cd-panel.is-visible {
        visibility: visible;
        -webkit-transition: visibility 0s 0s;
        -moz-transition: visibility 0s 0s;
        transition: visibility 0s 0s;
    }

    .cd-panel.is-visible::after {
        background: rgba(0, 0, 0, 0.6);
        -webkit-transition: background 0.3s 0s;
        -moz-transition: background 0.3s 0s;
        transition: background 0.3s 0s;
    }

    .cd-panel.is-visible .cd-panel-close::before {
        -webkit-animation: cd-close-1 0.6s 0.3s;
        -moz-animation: cd-close-1 0.6s 0.3s;
        animation: cd-close-1 0.6s 0.3s;
    }

    .cd-panel.is-visible .cd-panel-close::after {
        -webkit-animation: cd-close-2 0.6s 0.3s;
        -moz-animation: cd-close-2 0.6s 0.3s;
        animation: cd-close-2 0.6s 0.3s;
    }

    @-webkit-keyframes cd-close-1 {

        0%,
        50% {
            -webkit-transform: rotate(0);
        }

        100% {
            -webkit-transform: rotate(45deg);
        }
    }

    @-moz-keyframes cd-close-1 {

        0%,
        50% {
            -moz-transform: rotate(0);
        }

        100% {
            -moz-transform: rotate(45deg);
        }
    }

    @keyframes cd-close-1 {

        0%,
        50% {
            -webkit-transform: rotate(0);
            -moz-transform: rotate(0);
            -ms-transform: rotate(0);
            -o-transform: rotate(0);
            transform: rotate(0);
        }

        100% {
            -webkit-transform: rotate(45deg);
            -moz-transform: rotate(45deg);
            -ms-transform: rotate(45deg);
            -o-transform: rotate(45deg);
            transform: rotate(45deg);
        }
    }

    @-webkit-keyframes cd-close-2 {

        0%,
        50% {
            -webkit-transform: rotate(0);
        }

        100% {
            -webkit-transform: rotate(-45deg);
        }
    }

    @-moz-keyframes cd-close-2 {

        0%,
        50% {
            -moz-transform: rotate(0);
        }

        100% {
            -moz-transform: rotate(-45deg);
        }
    }

    @keyframes cd-close-2 {

        0%,
        50% {
            -webkit-transform: rotate(0);
            -moz-transform: rotate(0);
            -ms-transform: rotate(0);
            -o-transform: rotate(0);
            transform: rotate(0);
        }

        100% {
            -webkit-transform: rotate(-45deg);
            -moz-transform: rotate(-45deg);
            -ms-transform: rotate(-45deg);
            -o-transform: rotate(-45deg);
            transform: rotate(-45deg);
        }
    }

    .cd-panel-header {
        position: fixed;
        width: 90%;
        height: 50px;
        line-height: 50px;
        background: rgba(255, 255, 255, 0.96);
        z-index: 2;
        box-shadow: 0 1px 1px rgba(0, 0, 0, 0.08);
        -webkit-transition: top 0.3s 0s;
        -moz-transition: top 0.3s 0s;
        transition: top 0.3s 0s;
    }

    .cd-panel-header h1 {
        font-weight: bold;
        color: #89ba2c;
        padding-left: 5%;
    }

    .from-right .cd-panel-header,
    .from-left .cd-panel-header {
        top: -50px;
    }

    .from-right .cd-panel-header {
        right: 0;
    }

    .from-left .cd-panel-header {
        left: 0;
    }

    .is-visible .cd-panel-header {
        top: 0;
        -webkit-transition: top 0.3s 0.3s;
        -moz-transition: top 0.3s 0.3s;
        transition: top 0.3s 0.3s;
    }

    @media only screen and (min-width: 768px) {
        .cd-panel-header {
            width: 30%;
        }
    }

    @media only screen and (min-width: 1170px) {
        .cd-panel-header {
            width: 20%;
        }
    }

    .cd-panel-close {
        position: absolute;
        top: 0;
        right: 0;
        height: 100%;
        width: 60px;
        /* image replacement */
        display: inline-block;
        overflow: hidden;
        /*text-indent: 100%;*/
        white-space: nowrap;
    }

    .cd-panel-close::before,
    .cd-panel-close::after {
        /* close icon created in CSS */
        position: absolute;
        top: 22px;
        left: 20px;
        height: 3px;
        width: 20px;
        background-color: #424f5c;
        /* this fixes a bug where pseudo elements are slighty off position */
        -webkit-backface-visibility: hidden;
        backface-visibility: hidden;
    }

    .cd-panel-close::before {
        -webkit-transform: rotate(45deg);
        -moz-transform: rotate(45deg);
        -ms-transform: rotate(45deg);
        -o-transform: rotate(45deg);
        transform: rotate(45deg);
    }

    .cd-panel-close::after {
        -webkit-transform: rotate(-45deg);
        -moz-transform: rotate(-45deg);
        -ms-transform: rotate(-45deg);
        -o-transform: rotate(-45deg);
        transform: rotate(-45deg);
    }

    .no-touch .cd-panel-close:hover {
        background-color: #424f5c;
    }

    .no-touch .cd-panel-close:hover::before,
    .no-touch .cd-panel-close:hover::after {
        background-color: #ffffff;
        -webkit-transition-property: -webkit-transform;
        -moz-transition-property: -moz-transform;
        transition-property: transform;
        -webkit-transition-duration: 0.3s;
        -moz-transition-duration: 0.3s;
        transition-duration: 0.3s;
    }

    .no-touch .cd-panel-close:hover::before {
        -webkit-transform: rotate(220deg);
        -moz-transform: rotate(220deg);
        -ms-transform: rotate(220deg);
        -o-transform: rotate(220deg);
        transform: rotate(220deg);
    }

    .no-touch .cd-panel-close:hover::after {
        -webkit-transform: rotate(135deg);
        -moz-transform: rotate(135deg);
        -ms-transform: rotate(135deg);
        -o-transform: rotate(135deg);
        transform: rotate(135deg);
    }

    .cd-panel-container {
        position: fixed;
        width: 90%;
        height: 100%;
        top: 0;
        background: #dbe2e9;
        z-index: 1;
        -webkit-transition-property: -webkit-transform;
        -moz-transition-property: -moz-transform;
        transition-property: transform;
        -webkit-transition-duration: 0.3s;
        -moz-transition-duration: 0.3s;
        transition-duration: 0.3s;
        -webkit-transition-delay: 0.3s;
        -moz-transition-delay: 0.3s;
        transition-delay: 0.3s;
    }

    .from-right .cd-panel-container {
        right: 0;
        -webkit-transform: translate3d(100%, 0, 0);
        -moz-transform: translate3d(100%, 0, 0);
        -ms-transform: translate3d(100%, 0, 0);
        -o-transform: translate3d(100%, 0, 0);
        transform: translate3d(100%, 0, 0);
    }

    .from-left .cd-panel-container {
        left: 0;
        -webkit-transform: translate3d(-100%, 0, 0);
        -moz-transform: translate3d(-100%, 0, 0);
        -ms-transform: translate3d(-100%, 0, 0);
        -o-transform: translate3d(-100%, 0, 0);
        transform: translate3d(-100%, 0, 0);
    }

    .is-visible .cd-panel-container {
        -webkit-transform: translate3d(0, 0, 0);
        -moz-transform: translate3d(0, 0, 0);
        -ms-transform: translate3d(0, 0, 0);
        -o-transform: translate3d(0, 0, 0);
        transform: translate3d(0, 0, 0);
        -webkit-transition-delay: 0s;
        -moz-transition-delay: 0s;
        transition-delay: 0s;
    }

    @media only screen and (min-width: 768px) {
        .cd-panel-container {
            width: 30%;
        }
    }

    @media only screen and (min-width: 1170px) {
        .cd-panel-container {
            width: 20%;
        }
    }

    .cd-panel-content {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        padding: 70px 5%;
        overflow: auto;
        /* smooth scrolling on touch devices */
        -webkit-overflow-scrolling: touch;
    }

    .cd-panel-content p {
        font-size: 14px;
        font-size: 0.875rem;
        font-family: "Droid Serif", serif;
        color: #424f5c;
        line-height: 1.4;
        margin: 2em 0;
    }

    .cd-panel-content p:first-of-type {
        margin-top: 0;
    }

    @media only screen and (min-width: 768px) {
        .cd-panel-content p {
            font-size: 16px;
            font-size: 1rem;
            line-height: 1.6;
        }
    }

    .bg-green {
        background-color: green;
        color: #ffffff;
        font-weight: bold;
        border-radius: 10px 10px 10px 10px;
        -moz-border-radius: 10px 10px 10px 10px;
        -webkit-border-radius: 10px 10px 10px 10px;
        border: 4px solid #ffffff;
        margin-bottom: 5px;
        -webkit-box-shadow: 4px 9px 27px -9px rgba(0, 0, 0, 0.75);
        -moz-box-shadow: 4px 9px 27px -9px rgba(0, 0, 0, 0.75);
        box-shadow: 4px 9px 27px -9px rgba(0, 0, 0, 0.75);
    }

    .bg-red {
        background-color: red;
        color: #ffffff;
        font-weight: bold;
        border-radius: 10px 10px 10px 10px;
        -moz-border-radius: 10px 10px 10px 10px;
        -webkit-border-radius: 10px 10px 10px 10px;
        border: 4px solid #ffffff;
        margin-bottom: 5px;
        -webkit-box-shadow: 4px 9px 27px -9px rgba(0, 0, 0, 0.75);
        -moz-box-shadow: 4px 9px 27px -9px rgba(0, 0, 0, 0.75);
        box-shadow: 4px 9px 27px -9px rgba(0, 0, 0, 0.75);
    }

    .select {
        width: 100%;
        min-height: 2em;
        border-style: solid;
        border-width: 1px;
        border-radius: 3px;
        z-index: 0;
        padding: 5px;
    }

    .gradient1 {
        background-color: #fff;
        /* background-image: -webkit-gradient(linear, 0% 0%, 0% 100%, from(#ebebeb), to(#999999));
        background-image: -webkit-linear-gradient(top, #ebebeb, #999999);
        background-image: -moz-linear-gradient(top, #ebebeb, #999999);
        background-image: -ms-linear-gradient(top, #ebebeb, #999999);
        background-image: -o-linear-gradient(top, #ebebeb, #999999); */
    }

    .gradient2 {
        background-color: #fff;
        /* background-image: -webkit-gradient(linear, 0% 0%, 0% 100%, from(#ebebeb), to(#ebebeb));
        background-image: -webkit-linear-gradient(top, #999999, #ebebeb);
        background-image: -moz-linear-gradient(top, #999999, #ebebeb);
        background-image: -ms-linear-gradient(top, #999999, #ebebeb);
        background-image: -o-linear-gradient(top, #999999, #ebebeb); */
    }

    .list {
        position: relative;
        margin-left: -1px;
        padding: 0% 0% 0% 1px;
        width: 100%;
        height: auto;
        box-shadow: 0px 5px 10px #888888;
        border-style: solid;
        border-width: 1px;
        border-radius: 3px;
        background-color: #ebebeb;
        display: none;
        margin-top: -4px;
        z-index: 2;
    }

    .option {
        display: block;
        list-style-type: none;
        text-align: left;
    }

    .option:hover {
        background-color: grey;
        color: #ffffff;
    }

    .arrowDown {
        position: relative;
        top: -30%;
        left: 95%;
        width: 0%;
        height: 0%;
        border-left: 6px solid transparent;
        border-right: 6px solid transparent;
        border-top: 6px solid #444;
    }

    .value {
        position: relative;
        top: -2px;
        left: 0%;
        width: 100%;
        height: 100%;
        z-index: 1;
    }
</style>

<!--main-container-part-->
<div id="content" style="margin-left: 0px; margin-top: 40px;">
    <!--breadcrumbs-->
    <div id="content-header">
        <div id="breadcrumb"> <a href=" <?php echo site_url('admin'); ?>" title="Go to Home" class="tip-bottom"><i class="icon-home"></i> Home</a></div>
    </div>
    <!--End-breadcrumbs-->

    <?php
    if ($ujian->aktifkan_kamera == "YA"):
    ?>
        <!-- WEBCAM -->
        <div id="webcam" class="webcam-frame">
            <video id="video" autoplay></video>
        </div>

        <!-- Overlay untuk izin webcam -->
        <div id="overlay" class="overlay">
            <div class="overlay-text">Anda harus memberikan izin untuk mengakses webcam.</div>
            <button id="allow-button" class="allow-button">Klik di sini untuk mengizinkan browser mengakses webcam</button>
            <div class="overlay-instructions">Jika izin tidak muncul, silakan periksa pengaturan izin di browser Anda.</div>
        </div>

        <style>
            .webcam-frame {
                position: fixed;
                top: 20px;
                /* Posisi awal dari atas */
                right: 20px;
                /* Posisi awal dari kanan */
                width: 240px;
                /* Lebar frame (75% dari 320px) */
                height: 180px;
                /* Tinggi frame (75% dari 240px) */
                border: 2px solid #ccc;
                /* Gaya border */
                background-color: black;
                /* Warna latar belakang */
                cursor: move;
                /* Menunjukkan bahwa elemen dapat dipindahkan */
                z-index: 9999;
                /* Pastikan di atas elemen lain */
            }

            #video {
                width: 100%;
                /* Mengisi lebar frame */
                height: 100%;
                /* Mengisi tinggi frame */
            }

            /* Gaya untuk overlay */
            .overlay {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.7);
                /* Hitam dengan transparansi 70% */
                display: none;
                /* Sembunyikan overlay secara default */
                justify-content: center;
                /* Pusatkan konten secara horizontal */
                align-items: center;
                /* Pusatkan konten secara vertikal */
                flex-direction: column;
                /* Susun konten secara vertikal */
                z-index: 9998;
                /* Di bawah webcam frame */
            }

            .overlay-text {
                color: white;
                /* Warna teks */
                font-size: 20px;
                /* Ukuran font */
                text-align: center;
                /* Pusatkan teks */
                margin-bottom: 20px;
                /* Jarak antara teks dan tombol */
            }

            .allow-button {
                padding: 10px 20px;
                /* Padding tombol */
                font-size: 16px;
                /* Ukuran font tombol */
                color: white;
                /* Warna teks tombol */
                background-color: #007bff;
                /* Warna latar belakang tombol */
                border: none;
                /* Hapus border */
                border-radius: 5px;
                /* Sudut membulat */
                cursor: pointer;
                /* Tunjukkan bahwa ini adalah tombol */
            }

            .allow-button:hover {
                background-color: #0056b3;
                /* Warna latar belakang saat hover */
            }

            .overlay-instructions {
                color: white;
                /* Warna teks instruksi */
                font-size: 16px;
                /* Ukuran font instruksi */
                text-align: center;
                /* Pusatkan teks */
                margin-top: 10px;
                /* Jarak atas */
            }

            /* Media query untuk perangkat dengan lebar maksimum 768px */
            @media (max-width: 768px) {
                .webcam-frame {
                    width: 180px;
                    /* Lebar frame lebih kecil untuk perangkat seluler */
                    height: 115px;
                    /* Tinggi frame lebih kecil untuk perangkat seluler */
                    top: 10px;
                    /* Posisi dari atas */
                    right: 10px;
                    /* Posisi dari kanan */
                }
            }
        </style>

        <script>
            // Mengakses webcam
            const video = document.getElementById('video');
            const overlay = document.getElementById('overlay');
            const webcamFrame = document.getElementById('webcam');
            const allowButton = document.getElementById('allow-button');

            let inactivityTimeout;
            let snapshotInterval;
            const inactivityDuration = 10000; // 10 detik
            const snapshotIntervalDuration = 3000; // 3 detik

            function requestWebcamAccess() {
                console.log("Requesting webcam access...");
                navigator.mediaDevices.getUserMedia({
                        video: true
                    })
                    .then(stream => {
                        video.srcObject = stream;
                        overlay.style.display = 'none'; // Sembunyikan overlay jika izin diberikan
                        webcamFrame.style.display = 'block'; // Tampilkan frame webcam
                    })
                    .catch(err => {
                        console.error("Error accessing webcam: ", err);
                        overlay.style.display = 'flex'; // Tampilkan overlay jika izin tidak diberikan
                        webcamFrame.style.display = 'none'; // Sembunyikan frame webcam
                    });
            }

            // Minta akses webcam saat halaman dimuat
            requestWebcamAccess();

            // Tambahkan event listener untuk tombol
            allowButton.addEventListener('click', requestWebcamAccess);

            // Fungsionalitas drag-and-drop
            let isDragging = false;
            let offsetX, offsetY;

            webcamFrame.addEventListener('mousedown', (e) => {
                isDragging = true;
                offsetX = e.clientX - webcamFrame.getBoundingClientRect().left;
                offsetY = e.clientY - webcamFrame.getBoundingClientRect().top;
            });

            document.addEventListener('mousemove', (e) => {
                if (isDragging) {
                    webcamFrame.style.left = (e.clientX - offsetX) + 'px';
                    webcamFrame.style.top = (e.clientY - offsetY) + 'px';
                }
            });

            document.addEventListener('mouseup', () => {
                isDragging = false;
            });

            // Fungsi untuk mengirim snapshot
            function sendSnapshot() {
                const canvas = document.createElement('canvas');
                canvas.width = video.videoWidth;
                canvas.height = video.videoHeight;
                const context = canvas.getContext('2d');
                context.drawImage(video, 0, 0, canvas.width, canvas.height);

                canvas.toBlob(blob => {
                    const file = new File([blob], "snapshot.jpg", {
                        type: "image/jpeg"
                    });
                    const formData = new FormData();
                    formData.append('snapshot', file);
                    formData.append('idpeserta', '<?= $ujian->id_ujian_dilaksanakan . '' . $ujian->peserta ?>');

                    fetch('<?= site_url('ujian/send_snapshot') ?>', {
                            method: 'POST',
                            body: formData
                        })
                        .then(response => {
                            if (!response.ok) {
                                console.error('Error sending snapshot:', response.statusText);
                            }
                        })
                        .catch(err => {
                            console.error('Fetch error:', err);
                        });
                }, 'image/jpeg');
            }

            // Fungsi untuk mengatur timeout dan interval
            function resetInactivityTimer() {
                clearTimeout(inactivityTimeout);
                clearInterval(snapshotInterval);

                // Set timeout untuk mendeteksi ketidakaktifan
                inactivityTimeout = setTimeout(() => {
                    // Mulai mengirim snapshot setiap 3 detik
                    snapshotInterval = setInterval(sendSnapshot, snapshotIntervalDuration);
                }, inactivityDuration);
            }

            // Event listener untuk mendeteksi aktivitas pengguna
            document.addEventListener('mousemove', resetInactivityTimer);
            document.addEventListener('keydown', resetInactivityTimer);
            document.addEventListener('click', resetInactivityTimer);
            document.addEventListener('scroll', resetInactivityTimer);

            // Reset timer saat halaman dimuat
            resetInactivityTimer();
        </script>
        <!-- END WEBCAM -->
    <?php endif; ?>

    <!--Action boxes-->
    <div class="container-fluid">
        <div class="row-fluid">
            <div class="span2">
                <div class="widget-box">
                    <div class="widget-content">
                        <a href="#" class="btn btn-block btn-warning btn-flat btn-lg" data-toggle="control-sidebar" style="white-space:normal !important; word-wrap:break-word; " id="show_panel"><i class="fa fa-list-alt"></i> Daftar Soal</a>
                    </div>
                </div>

            </div>
            <div class="span3">
                <div class="widget-box">
                    <div class="widget-content">
                        <div style="border-bottom: 1px solid;margin-bottom: 10px;"><a href="javascript:;" class="" data-toggle="modal" data-target="#modal-keterangan-paket-soal">ℹ️ Info Ujian</a></div>
                        Soal No: <?php echo $soal->no; ?> Dari <?php echo $ujian->jumlah_soal; ?> Soal
                    </div>
                </div>
            </div>
            <div class="span7">
                <div class="widget-box">
                    <div class="widget-content">
                        <span class="info-box-text">Waktu Ujian</span>
                        <span class="info-box-number"> <?php echo $ujian->lama_ujian ?> Menit, </span><span class="progress-description">Sisa Waktu <span id="time"></span> Menit</span>
                        <div class="progress">
                            <div class="bar" style="width: 100%" id="progress"></div>
                        </div>

                    </div>
                </div>
            </div><!-- /.col -->
        </div>
        <div class="row-fluid">
            <div class="span12">
                <?php
                if ($soal->video_file != "") {
                ?>
                    <link href=" <?php echo base_url('assets'); ?>/dist/skin/blue.monday/css/jplayer.blue.monday.min.css" rel="stylesheet" type="text/css" />
                    <script src=" <?php echo base_url('assets'); ?>/dist/jplayer/jquery.jplayer.min.js"></script>
                    <script type="text/javascript">
                        $(document).ready(function() {

                            $("#jquery_jplayer_1").jPlayer({
                                ready: function() {
                                    $(this).jPlayer("setMedia", {
                                        title: "Video File",
                                        m4v: " <?php echo base_url('assets/video/' . $soal->video_file); ?>",
                                        poster: " <?php echo base_url('assets/admin/player/css/bg_image.jpg'); ?>"
                                    });
                                },
                                cssSelectorAncestor: "#jp_container_1",
                                swfPath: " <?php echo base_url('assets'); ?>/dist/jplayer/",
                                supplied: "m4v",
                                useStateClassSkin: true,
                                autoBlur: false,
                                smoothPlayBar: true,
                                keyEnabled: true,
                                remainingDuration: true,
                                toggleDuration: true
                            });
                        });
                    </script>
                    <div class="col-md-6 col-sm-12 col-xs-12">
                        <div class="box box-warning">
                            <div class="box-header with-border">
                                <h3 class="box-title">Klik untuk mendengarkan Soal Video</h3>
                            </div>
                            <div class="box-body">
                                <div id="jp_container_1" class="jp-video " role="application" aria-label="media player">
                                    <div class="jp-type-single">
                                        <div id="jquery_jplayer_1" class="jp-jplayer"></div>
                                        <div class="jp-gui">
                                            <div class="jp-video-play">
                                                <button class="jp-video-play-icon" role="button" tabindex="0">play</button>
                                            </div>
                                            <div class="jp-interface">
                                                <div class="jp-progress">
                                                    <div class="jp-seek-bar">
                                                        <div class="jp-play-bar"></div>
                                                    </div>
                                                </div>
                                                <div class="jp-current-time" role="timer" aria-label="time">&nbsp;</div>
                                                <div class="jp-duration" role="timer" aria-label="duration">&nbsp;</div>
                                                <div class="jp-details">
                                                    <div class="jp-title" aria-label="title">&nbsp;</div>
                                                </div>
                                                <div class="jp-controls-holder">
                                                    <div class="jp-volume-controls">
                                                        <button class="jp-mute" role="button" tabindex="0">mute</button>
                                                        <button class="jp-volume-max" role="button" tabindex="0">max volume</button>
                                                        <div class="jp-volume-bar">
                                                            <div class="jp-volume-bar-value"></div>
                                                        </div>
                                                    </div>
                                                    <div class="jp-controls">
                                                        <button class="jp-play" role="button" tabindex="0">play</button>
                                                        <button class="jp-stop" role="button" tabindex="0">stop</button>
                                                    </div>
                                                    <div class="jp-toggles">
                                                        <button class="jp-repeat" role="button" tabindex="0">repeat</button>
                                                        <button class="jp-full-screen" role="button" tabindex="0">full screen</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="jp-no-solution">
                                            <span>Update Required</span>
                                            To play the media you will need to either update your browser to a recent version or update your <a href="http://get.adobe.com/flashplayer/" target="_blank">Flash plugin</a>.
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php
                }
                ?>
                <?php
                if ($soal->audio_file != "") {
                ?>
                    <link href=" <?php echo base_url('assets'); ?>/dist/skin/blue.monday/css/jplayer.blue.monday.min.css" rel="stylesheet" type="text/css" />
                    <script src=" <?php echo base_url('assets'); ?>/dist/jplayer/jquery.jplayer.min.js"></script>
                    <script type="text/javascript">
                        $(document).ready(function() {
                            $("#audio_player").jPlayer({
                                ready: function() {
                                    $(this).jPlayer("setMedia", {
                                        title: "Soal Audio",
                                        mp3: " <?php echo base_url('assets/audio/' . $soal->audio_file); ?>",
                                    });
                                },
                                cssSelectorAncestor: "#audio_player_container",
                                swfPath: ' <?php echo base_url('assets'); ?>/dist/jplayer/',
                                supplied: "mp3",
                                wmode: "window",
                                useStateClassSkin: true,
                                autoBlur: false,
                                smoothPlayBar: true,
                                keyEnabled: true,
                                remainingDuration: true,
                                toggleDuration: true
                            });
                        });
                    </script>
                    <div class="col-md-6 col-sm-12 col-xs-12">
                        <div class="box box-danger">
                            <div class="box-header with-border">
                                <h3 class="box-title">Klik untuk melihat Soal Audio</h3>
                            </div>
                            <div class="box-body">
                                <div id="audio_player" class="jp-jplayer"></div>
                                <div id="audio_player_container" class="jp-audio" role="application" aria-label="media player">
                                    <div class="jp-type-single">
                                        <div class="jp-gui jp-interface">
                                            <div class="jp-controls">
                                                <button class="jp-play" role="button" tabindex="0">play</button>
                                                <button class="jp-stop" role="button" tabindex="0">stop</button>
                                            </div>
                                            <div class="jp-progress">
                                                <div class="jp-seek-bar">
                                                    <div class="jp-play-bar"></div>
                                                </div>
                                            </div>
                                            <div class="jp-volume-controls">
                                                <button class="jp-mute" role="button" tabindex="0">mute</button>
                                                <button class="jp-volume-max" role="button" tabindex="0">max volume</button>
                                                <div class="jp-volume-bar">
                                                    <div class="jp-volume-bar-value"></div>
                                                </div>
                                            </div>
                                            <div class="jp-time-holder">
                                                <div class="jp-current-time" role="timer" aria-label="time">&nbsp;</div>
                                                <div class="jp-duration" role="timer" aria-label="duration">&nbsp;</div>
                                                <div class="jp-toggles">
                                                    <button class="jp-repeat" role="button" tabindex="0">repeat</button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="jp-details">
                                            <div class="jp-title" aria-label="title">&nbsp;</div>
                                        </div>
                                        <div class="jp-no-solution">
                                            <span>Update Required</span>
                                            To play the media you will need to either update your browser to a recent version or update your <a href="http://get.adobe.com/flashplayer/" target="_blank">Flash plugin</a>.
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php
                }
                ?>
                <div class="row-fluid">
                    <div class="span12">
                        <div class="widget-box">
                            <div class="widget-title"> <span class="icon"> <i class="icon-list"></i> </span>
                                <h5>Pertanyaan ke <?php echo $soal->no; ?> [Tipe Soal: <?php echo $soal->jenis_soal; ?>]</h5> <span class="pull-right" style="padding: 12px">Ukuran: <a href="javascript:;" id="ukuran_kecil" style="color: red; font-size: 12px; font-weight: bold">A</a> <a href="javascript:;" id="ukuran_sedang" style="color: red; font-size: 16px; font-weight: bold">A</a> <a href="javascript:;" id="ukuran_besar" style="color: red; font-size: 20px; font-weight: bold">A</a></span>
                            </div>
                            <div class="widget-content pertanyaan">
                                <?php
                                echo $soal->deskripsi_soal;
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
                <form action=" <?php echo site_url('ujian/simpan_jawaban'); ?>" method="POST">
                    <input type="hidden" name="soal_ujian" value="<?php echo $soal->id_soal_ujian; ?>" />
                    <input type="hidden" name="id_detail_ujian" value="<?php echo $ujian->detail_jadwal_ujian; ?>" />
                    <input type="hidden" name="id_ujian_dilaksanakan" value="<?php echo $ujian->id_ujian_dilaksanakan; ?>" />
                    <?php
                    if ($soal->jenis_soal == 'ESSAY' || $soal->jenis_soal == 'JAWABAN SINGKAT') {
                    ?>
                        <h3>Jawaban:</h3>
                        <textarea name="jawaban" class="form-control" style="width: 100%" rows="5"> <?php echo $soal->jawaban_essay ?></textarea>
                        <button type="submit" class="btn btn-success" name="simpan_essay" value="simpan">Simpan jawaban</button>
                    <?php
                    } elseif ($soal->jenis_soal == 'BENAR SALAH KOMPLEKS') {
                        $desk = $soal->jawaban_bs_multi != "" ? json_decode($soal->jawaban_bs_multi) : [];

                        $jb = $soal->jawaban_lain != "" ? json_decode($soal->jawaban_lain) : [];
                    ?>
                        <table class="table">
                            <tr>
                                <td style="width: 20px;">#</td>
                                <td>Soal</td>
                                <td style="width: 50px;">Benar</td>
                                <td style="width: 50px;">Salah</td>
                            </tr>
                            <?php
                            $no = 0;
                            foreach ($desk as $v) {
                                $no++;
                                $item = isset($jb[$no - 1]) ? $jb[$no - 1] : "";
                            ?>
                                <tr>
                                    <td> <?php echo $no; ?></td>
                                    <td> <?php echo $v->pernyataan; ?></td>
                                    <td style="text-align: center;"><input type="radio" id="benar" name="jawaban_<?php echo $no - 1; ?>" value="BENAR" <?php echo $item == "BENAR" ? "checked" : ""; ?>></td>
                                    <td style="text-align: center;"><input type="radio" id="salah" name="jawaban_<?php echo $no - 1; ?>" value="SALAH" <?php echo $item == "SALAH" ? "checked" : ""; ?>></td>
                                </tr>
                            <?php
                            }
                            ?>
                        </table>
                        <button type="submit" class="btn btn-success" name="simpan_essay" value="simpan">Simpan jawaban</button>
                    <?php
                    } elseif ($soal->jenis_soal == 'MENGURUTKAN') {
                        $desk = $soal->jawaban_mengurutkan != "" ? json_decode($soal->jawaban_mengurutkan) : [];
                        shuffle($desk);

                        $jb = $soal->jawaban_lain != "" ? json_decode($soal->jawaban_lain) : [];
                    ?>
                        <table class="table">
                            <tr>
                                <td style="width: 20px;">#</td>
                                <td>Soal</td>
                                <td style="width: 50px;">Urutan</td>
                            </tr>
                            <?php
                            $no = 0;
                            foreach ($desk as $v) {
                                $urutan = $v->urutan;
                                $no++;
                                $item = isset($jb->$urutan) ? $jb->$urutan : "";
                            ?>
                                <tr>
                                    <td> <?php echo $no; ?></td>
                                    <td> <?php echo $v->pertanyaan; ?></td>
                                    <td style="text-align: center;"><input type="number" name="jawaban_ <?php echo $v->urutan; ?>" value=" <?php echo $item; ?>"></td>
                                </tr>
                            <?php
                            }
                            ?>
                        </table>
                        <button type="submit" class="btn btn-success" name="simpan_essay" value="simpan">Simpan jawaban</button>
                    <?php
                    } elseif ($soal->jenis_soal == 'MENJODOHKAN') {
                        $desk          = $soal->jawaban_menjodohkan != "" ? json_decode($soal->jawaban_menjodohkan) : [];
                        $ar_pernyataan = array('' => '');
                        $no            = 0;
                        foreach ($desk->pernyataan as $v) {
                            $no++;
                            $ar_pernyataan["X" . $no] = $v;
                        }

                        $ar_pasangan = array('' => '');
                        $no          = 0;
                        foreach ($desk->pasangan as $v) {
                            $no++;
                            $ar_pasangan["Y" . $no] = $v;
                        }

                        $jb = $soal->jawaban_lain != "" ? json_decode($soal->jawaban_lain) : [];
                    ?>
                        <table class="table">
                            <tr>
                                <td>Pernyataan</td>
                                <td>Pasangan</td>
                            </tr>
                            <?php
                            $max_no = count($desk->pernyataan) > count($desk->pasangan) ? count($desk->pernyataan) : count($desk->pasangan);
                            for ($i = 1; $i <= $max_no; $i++) {
                                $sel1 = "";
                                $sel2 = "";
                                if (isset($jb[$i - 1])) {
                                    $item = explode("*", $jb[$i - 1]);
                                    $sel1 = $item[0];
                                    $sel2 = $item[1];
                                }
                            ?>
                                <tr>
                                    <td>
                                        <div id="<?php echo "dr_pernyataan_" . $i; ?>" class="select">
                                            <input type="hidden" name="<?php echo "pernyataan_" . $i; ?>" class="jawaban" value="<?php echo $sel1; ?>">
                                            <div class="arrowDown"></div>
                                            <ul class="list">
                                                <?php
                                                $val = "";
                                                foreach ($ar_pernyataan as $k => $v) {
                                                    if ($sel1 == $k) {
                                                        $val = $v;
                                                    }
                                                    echo '<li class="option" data="' . $k . '" tipe="X">' . $v . '</li>';
                                                }
                                                ?>
                                            </ul>
                                            <div class="value"><?php echo $val; ?></div>
                                        </div>

                                        <?php //echo form_dropdown("pernyataan_" . $i, $ar_pernyataan, $sel1); 
                                        ?>
                                    </td>
                                    <td>
                                        <div id="<?php echo "dr_pasangan_" . $i; ?>" class="select">
                                            <input type="hidden" name="<?php echo "pasangan_" . $i; ?>" class="pasangan" value="<?php echo $sel2; ?>">
                                            <div class="arrowDown"></div>
                                            <ul class="list">
                                                <?php
                                                $val = "";
                                                foreach ($ar_pasangan as $k => $v) {
                                                    if ($sel2 == $k) {
                                                        $val = $v;
                                                    }
                                                    echo '<li class="option" data="' . $k . '" tipe="Y">' . $v . '</li>';
                                                }
                                                ?>
                                            </ul>
                                            <div class="value"><?php echo $val; ?></div>
                                        </div>
                                        <?php //echo form_dropdown("pasangan_" . $i, $ar_pasangan, $sel2); 
                                        ?>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                        </table>
                        <button type="submit" class="btn btn-success" name="simpan_essay" value="simpan">Simpan jawaban</button>
                    <?php
                    } elseif ($soal->jenis_soal == 'BENAR SALAH') {
                    ?>
                        <h3>Jawaban:</h3>
                        <table class="table">
                            <tr>
                                <td style="width: 20px;"><input type="radio" id="benar" name="jawaban" value="BENAR" <?php echo $soal->jawaban_bs == "BENAR" ? "checked" : ""; ?>></td>
                                <td style="width: 100px;"> <label for="benar">BENAR</label><br></td>
                                <td style="width: 20px;"> <input type="radio" id="salah" name="jawaban" value="SALAH" <?php echo $soal->jawaban_bs == "SALAH" ? "checked" : ""; ?>></td>
                                <td> <label for="salah">SALAH</label><br></td>
                            </tr>
                        </table>
                        <button type="submit" class="btn btn-success" name="simpan_benar_salah" value="simpan">Simpan jawaban</button>
                    <?php
                    } elseif ($soal->jenis_soal == 'PILIHAN GANDA') {
                    ?>
                        <div class="row-fluid">
                            <div class="span6 jawaban">
                                <div class="row-fluid">
                                    <div class="span2">
                                        <?php
                                        $clean_ans = trim(strip_tags($soal->jawaban_e));

                                        if ($clean_ans != "---" && $clean_ans != '-') {
                                            $jb = array('a', 'b', 'c', 'd', 'e');

                                            $ran = range(0, 4);
                                            shuffle($ran);
                                            $a = $jb[$ran[0]];
                                            $b = $jb[$ran[1]];
                                            $c = $jb[$ran[2]];
                                            $d = $jb[$ran[3]];
                                            $e = $jb[$ran[4]];
                                        } else {
                                            $jb = array('a', 'b', 'c', 'd');

                                            $ran = range(0, 3);
                                            shuffle($ran);
                                            $a = $jb[$ran[0]];
                                            $b = $jb[$ran[1]];
                                            $c = $jb[$ran[2]];
                                            $d = $jb[$ran[3]];
                                        }

                                        $cl = 'btn-default';
                                        if ($jawaban[$soal->no] == strtoupper($a)) {
                                            $cl = 'btn-primary';
                                        }
                                        ?>
                                        <a href=" <?php echo site_url('ujian/simpan_jawaban/' . $soal->id_soal_ujian . '/' . $ujian->id_ujian_dilaksanakan . '/' . strtoupper($a)); ?>" class="btn <?php echo $cl; ?> btn-circle btn-lg" id="jawaban_a"><strong>A</strong></a>
                                    </div>
                                    <div class="span10">
                                        <?php
                                        $str_jb = 'jawaban_' . $a;
                                        echo $soal->$str_jb;
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <div class="span6 jawaban">
                                <div class="row-fluid">
                                    <div class="span2">
                                        <?php
                                        $cl = 'btn-default';
                                        if ($jawaban[$soal->no] == strtoupper($b)) {
                                            $cl = 'btn-primary';
                                        }
                                        ?>
                                        <a href=" <?php echo site_url('ujian/simpan_jawaban/' . $soal->id_soal_ujian . '/' . $ujian->id_ujian_dilaksanakan . '/' . strtoupper($b)); ?>" class="btn <?php echo $cl; ?>  btn-circle btn-lg" id="jawaban_b"><strong>B</strong></a>
                                    </div>
                                    <div class="span10">
                                        <?php
                                        $str_jb = 'jawaban_' . $b;
                                        echo $soal->$str_jb;
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row-fluid">
                            <div class="span6 jawaban">
                                <div class="row-fluid">
                                    <div class="span2">
                                        <?php
                                        $cl = 'btn-default';
                                        if ($jawaban[$soal->no] == strtoupper($c)) {
                                            $cl = 'btn-primary';
                                        }
                                        ?>
                                        <a href=" <?php echo site_url('ujian/simpan_jawaban/' . $soal->id_soal_ujian . '/' . $ujian->id_ujian_dilaksanakan . '/' . strtoupper($c)); ?>" class="btn <?php echo $cl; ?> btn-circle btn-lg" id="jawaban_c"><strong>C</strong></a>
                                    </div>
                                    <div class="span10">
                                        <?php
                                        $str_jb = 'jawaban_' . $c;
                                        echo $soal->$str_jb;
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <div class="span6 jawaban">
                                <div class="row-fluid">
                                    <div class="span2">
                                        <?php
                                        $cl = 'btn-default';
                                        if ($jawaban[$soal->no] == strtoupper($d)) {
                                            $cl = 'btn-primary';
                                        }
                                        ?>
                                        <a href=" <?php echo site_url('ujian/simpan_jawaban/' . $soal->id_soal_ujian . '/' . $ujian->id_ujian_dilaksanakan . '/' . strtoupper($d)); ?>" class="btn <?php echo $cl; ?> btn-circle btn-lg" id="jawaban_d"><strong>D</strong></a>
                                    </div>
                                    <div class="span10">
                                        <?php
                                        $str_jb = 'jawaban_' . $d;
                                        echo $soal->$str_jb;
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row-fluid">
                            <?php
                            if ($clean_ans != "---" && $clean_ans != '-') {
                            ?>
                                <div class="span6 jawaban">
                                    <div class="row-fluid">
                                        <div class="span2">
                                            <?php
                                            $cl = 'btn-default';
                                            if ($jawaban[$soal->no] == strtoupper($e)) {
                                                $cl = 'btn-primary';
                                            }
                                            ?>
                                            <a href=" <?php echo site_url('ujian/simpan_jawaban/' . $soal->id_soal_ujian . '/' . $ujian->id_ujian_dilaksanakan . '/' . strtoupper($e)); ?>" class="btn <?php echo $cl; ?> btn-circle btn-lg" id="jawaban_e"><strong>E</strong></a>
                                        </div>
                                        <div class="span10">
                                            <?php
                                            $str_jb = 'jawaban_' . $e;
                                            echo $soal->$str_jb;
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            <?php
                            }
                            ?>
                        </div>
                    <?php
                    } elseif ($soal->jenis_soal == 'PILIHAN GANDA KOMPLEKS') {
                        $jb = $soal->jawaban_pg_multi;
                        $arr_jawaban = explode(",", $jb);
                    ?>
                        <input type="hidden" id="jawaban_pg_ulti" name="jawaban_pg_ulti" value="<?php echo $jb; ?>">
                        <div class="row-fluid">
                            <div class="span6 jawaban">
                                <div class="row-fluid">
                                    <div class="span2">
                                        <?php
                                        $clean_ans = trim(strip_tags($soal->jawaban_e));

                                        if ($clean_ans != "---" && $clean_ans != '-') {
                                            $jb = array('a', 'b', 'c', 'd', 'e');

                                            $ran = range(0, 4);
                                            shuffle($ran);
                                            $a = $jb[$ran[0]];
                                            $b = $jb[$ran[1]];
                                            $c = $jb[$ran[2]];
                                            $d = $jb[$ran[3]];
                                            $e = $jb[$ran[4]];
                                        } else {
                                            $jb = array('a', 'b', 'c', 'd');

                                            $ran = range(0, 3);
                                            shuffle($ran);
                                            $a = $jb[$ran[0]];
                                            $b = $jb[$ran[1]];
                                            $c = $jb[$ran[2]];
                                            $d = $jb[$ran[3]];
                                        }

                                        $cl = 'btn-default';
                                        if (in_array(strtoupper($a), $arr_jawaban)) {
                                            $cl = 'btn-primary';
                                        }

                                        ?>
                                        <a onclick="pg_multi('jawaban_a', '<?php echo strtoupper($a); ?>')" class="btn <?php echo $cl; ?> btn-circle btn-lg" id="jawaban_a"><strong>A</strong></a>
                                    </div>
                                    <div class="span10">
                                        <?php
                                        $str_jb = 'jawaban_' . $a;
                                        echo $soal->$str_jb;
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <div class="span6 jawaban">
                                <div class="row-fluid">
                                    <div class="span2">
                                        <?php
                                        $cl = 'btn-default';
                                        if (in_array(strtoupper($b), $arr_jawaban)) {
                                            $cl = 'btn-primary';
                                        }
                                        ?>
                                        <a onclick="pg_multi('jawaban_b', '<?php echo strtoupper($b); ?>')" class="btn <?php echo $cl; ?>  btn-circle btn-lg" id="jawaban_b"><strong>B</strong></a>
                                    </div>
                                    <div class="span10">
                                        <?php
                                        $str_jb = 'jawaban_' . $b;
                                        echo $soal->$str_jb;
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row-fluid">
                            <div class="span6 jawaban">
                                <div class="row-fluid">
                                    <div class="span2">
                                        <?php
                                        $cl = 'btn-default';
                                        if (in_array(strtoupper($c), $arr_jawaban)) {
                                            $cl = 'btn-primary';
                                        }
                                        ?>
                                        <a onclick="pg_multi('jawaban_c', '<?php echo strtoupper($c); ?>')" class="btn <?php echo $cl; ?> btn-circle btn-lg" id="jawaban_c"><strong>C</strong></a>
                                    </div>
                                    <div class="span10">
                                        <?php
                                        $str_jb = 'jawaban_' . $c;
                                        echo $soal->$str_jb;
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <div class="span6 jawaban">
                                <div class="row-fluid">
                                    <div class="span2">
                                        <?php
                                        $cl = 'btn-default';
                                        if (in_array(strtoupper($d), $arr_jawaban)) {
                                            $cl = 'btn-primary';
                                        }
                                        ?>
                                        <a onclick="pg_multi('jawaban_d', '<?php echo strtoupper($d); ?>')" class="btn <?php echo $cl; ?> btn-circle btn-lg" id="jawaban_d"><strong>D</strong></a>
                                    </div>
                                    <div class="span10">
                                        <?php
                                        $str_jb = 'jawaban_' . $d;
                                        echo $soal->$str_jb;
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row-fluid">
                            <?php
                            if ($clean_ans != "---" && $clean_ans != '-') {
                            ?>
                                <div class="span6 jawaban">
                                    <div class="row-fluid">
                                        <div class="span2">
                                            <?php
                                            $cl = 'btn-default';
                                            if (in_array(strtoupper($e), $arr_jawaban)) {
                                                $cl = 'btn-primary';
                                            }
                                            ?>
                                            <a onclick="pg_multi('jawaban_e', '<?php echo strtoupper($e); ?>')" class="btn <?php echo $cl; ?> btn-circle btn-lg" id="jawaban_e"><strong>E</strong></a>
                                        </div>
                                        <div class="span10">
                                            <?php
                                            $str_jb = 'jawaban_' . $e;
                                            echo $soal->$str_jb;
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            <?php
                            }
                            ?>
                        </div>
                        <button type="submit" class="btn btn-success" name="simpan_benar_salah" value="simpan">Simpan jawaban</button>
                    <?php
                    }
                    ?>
                    <hr />

                    <div class="row-fluid">
                        <div class="span5">
                            <a href=" <?php echo site_url('ujian/do_ujian/' . $ujian->id_ujian_dilaksanakan) . '/' . (($soal->no <= 1) ? 1 : ($soal->no - 1)); ?>" class="btn btn-block btn-success btn-flat btn-lg"><i class="icon icon-arrow-left"></i> Soal Sebelumnya</a>
                            <hr />
                        </div>
                        <div class="span2">

                        </div>
                        <div class="span5">
                            <a href=" <?php echo site_url('ujian/do_ujian/' . $ujian->id_ujian_dilaksanakan) . '/' . (($ujian->jumlah_soal <= $soal->no) ? $ujian->jumlah_soal : ($soal->no + 1)); ?>" class="btn btn-block btn-primary btn-flat btn-lg"><i class="icon icon-arrow-right"></i> Soal Selanjutnya</a>
                            <hr />
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<modal id="modal-keterangan-paket-soal" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Keterangan Paket Soal</h4>
            </div>
            <div class="modal-body">
                <?php echo str_replace(" Nama:", "<br><b>Nama:</b>", str_replace(", Mapel:", "<br><b>Mata Pelajaran:</b>", str_replace(", PAKET SOAL:", "<br><b>PAKET SOAL:</b>", $ujian->keterangan_paket_soal))); ?>
            </div>
        </div>
    </div>
</modal>

<div class="cd-panel from-right" id="panel">
    <header class="cd-panel-header">
        <h4 style="padding-left: 20px;">Daftar Soal</h4>
        <a href="#0" class="cd-panel-close btn btn-danger" id="close_panel" style="height: 20px; top: 4px; right: 4px">Close</a>
    </header>

    <div class="cd-panel-container">
        <div class="cd-panel-content">
            <?php
            for ($i = 1; $i <= $ujian->jumlah_soal; $i++) {
                //cek jawaban
                $bg = 'bg-green';
                if ($mark[$i] == 'T') {
                    $bg = 'bg-red';
                }
            ?>
                <a class="btn btn-app  <?php echo $bg; ?>" href=" <?php echo site_url('ujian/do_ujian/' . $ujian->id_ujian_dilaksanakan) . '/' . $i; ?>" style="border: 1px solid #ffffff">
                    <?php echo sprintf('%02d', $i); ?>
                </a>
            <?php
            }
            ?>
        </div> <!-- cd-panel-content -->
    </div> <!-- cd-panel-container -->
</div> <!-- cd-panel -->

<!-- Bootstrap Modal -->
<div class="modal fade" id="timeUpModal" tabindex="-1" aria-labelledby="timeUpModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="timeUpModalLabel">Waktu Habis</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Waktu mengerjakan sudah habis.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="okButton">OK</button>
            </div>
        </div>
    </div>
</div>


<script>
    function pg_multi(item, jb) {
        let jbMulti = $('#jawaban_pg_ulti').val();

        let arJb = jbMulti.split(",");

        if (arJb.includes(jb)) {
            const index = arJb.indexOf(jb);
            if (index > -1) {
                arJb.splice(index, 1);
            }
        } else {
            arJb.push(jb);
        }

        const value = arJb.join(",");
        $('#jawaban_pg_ulti').val(value);

        $("#" + item).toggleClass('btn-primary');
    }

    $('#show_panel').click(function(e) {
        $('#panel').toggleClass('is-visible');
    });
    $('#close_panel').click(function(e) {
        $('#panel').toggleClass('is-visible');
    });

    $('#ukuran_besar').click(function(e) {
        $('.pertanyaan').each(function(i) {
            $(this).css('font-size', '20px');
        });
        $('.jawaban').each(function(i) {
            $(this).css('font-size', '20px');
        });
    });

    $('#ukuran_sedang').click(function(e) {
        $('.pertanyaan').each(function(i) {
            $(this).css('font-size', '16px');
        });
        $('.jawaban').each(function(i) {
            $(this).css('font-size', '16px');
        });
    });

    $('#ukuran_kecil').click(function(e) {
        $('.pertanyaan').each(function(i) {
            $(this).css('font-size', '12px');
        });
        $('.jawaban').each(function(i) {
            $(this).css('font-size', '12px');
        });
    });

    function startTimer(duration, display) {
        var timer = duration,
            minutes, seconds;
        setInterval(function() {
            minutes = parseInt(timer / 60, 10);
            seconds = parseInt(timer % 60, 10);
            minutes = minutes < 10 ? "0" + minutes : minutes;
            seconds = seconds < 10 ? "0" + seconds : seconds;
            display.text(minutes + ":" + seconds);
            var total = <?php echo $ujian->lama_ujian ?> * 60;
            var persen = (duration / total) * 100;
            console.log(persen);
            document.getElementById("progress").style["width"] = persen + "%";
            if (--timer < 0) {
                timer = duration;
                // Show the modal when the time is up
                $('#timeUpModal').modal('show');
            }
        }, 1000);

        // Handle the "OK" button click event
        $('#okButton').on('click', function() {
            window.location.href = "<?php echo site_url('ujian/selesaikan_ujian/' . $ujian->id_ujian_dilaksanakan); ?>";
        });
    }


    window.onload = function() {
        var fiveMinutes = 60 * <?php echo $sisa; ?>,
            display = $('#time');
        startTimer(fiveMinutes, display);
    };

    $(function() {
        $(window).on("load", function() {
            $(window).off("load");
            var selects = $(".select");

            function getTextValue(selectId) {
                var select = $("#" + selectId),
                    values,
                    text = "";

                if (select.length) {
                    values = select.find(".value");
                    if (values.length) {
                        text = values.first().text();
                    }
                }

                return text;
            }

            function getHTMLValue(selectId) {
                var select = $("#" + selectId),
                    values,
                    html = "";

                if (select.length) {
                    values = select.find(".value");
                    if (values.length) {
                        html = values.first().html();
                    }
                }

                return html;
            }

            function hideAll(not) {
                selects.not(not).each(function() {
                    var select = $(this);
                    select.find(".list").hide();
                    select.removeClass("gradient1 gradient2").addClass("gradient1");
                });
            }

            $(document).on("click", hideAll);

            selects.each(function() {
                var select = $(this);
                select.addClass("gradient1");
                var lists = select.find(".list"),
                    options,
                    values,
                    value,
                    pasangan,
                    jawaban;

                if (lists.length) {
                    options = lists.first().find(".option");
                    if (options.length) {
                        values = select.find(".value");
                        jawaban = select.find('.jawaban');
                        pasangan = select.find('.pasangan');

                        if (values.length) {
                            value = values.first();

                            let isi = jawaban.val();
                            let isi1 = pasangan.val();
                            if (isi === "" || isi1 === "") {
                                value.html(options.first().html());
                            }

                            options.on("click", function() {
                                // console.log($(this).attr("data"));
                                let tipe = $(this).attr("tipe");
                                if (tipe === "X") {
                                    jawaban.val($(this).attr("data"));
                                } else {
                                    pasangan.val($(this).attr("data"));

                                }
                                value.html($(this).html());
                            });
                        }
                    }
                }

                select.on("click", function(evt) {
                    evt.stopPropagation();
                    hideAll(this);
                    var lists = $(this).find(".list"),
                        list;

                    if (lists.length) {
                        list = lists.first();

                        if (list.css("display") === "none") {
                            list.show();
                        } else {
                            list.hide();
                        }
                    }

                    if ($(this).hasClass("gradient1")) {
                        $(this).removeClass("gradient1").addClass("gradient2");
                    } else {
                        $(this).removeClass("gradient1 gradient2").addClass("gradient1");
                    }
                });
            });
        });
    });
</script>
