<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Login Pengguna</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=yes">
    <link rel="stylesheet" href="<?php echo base_url('assets/font'); ?>/open_sans.css">
    <link rel="stylesheet" href="<?php echo base_url('assets/login'); ?>/css.css">
</head>

<body>
    <div class="cont">
        <div class="demo">
            <div class="login">
                <?php
                $kartu = $this->db->from('setting_kartu')->limit(1)->get()->row();
                $images = 'assets/uploads/' . $kartu->logo;

                if (file_exists($images)) {
                    $logo = base_url('assets/uploads/') . $kartu->logo;
                } else {
                    $logo = base_url('assets/login/logo-sekolah.png');
                }

                ?>
                <div style="text-align: center; padding-top: 50px;"><img src="<?php echo $logo; ?>" style="width: 200px; height: auto;" alt="Logo" /></div>
                <div class="login__form">
                    <form action="<?php echo site_url('home/do_login'); ?>" id="login_form" method="POST">
                        <div class="login__row">
                            <svg class="login__icon name svg-icon" viewBox="0 0 20 20">
                                <path d="M0,20 a10,8 0 0,1 20,0z M10,0 a4,4 0 0,1 0,8 a4,4 0 0,1 0,-8" />
                            </svg>
                            <input type="text" class="login__input name" placeholder="Username" name="txt_username" />
                        </div>
                        <div class="login__row">
                            <svg class="login__icon pass svg-icon" viewBox="0 0 20 20">
                                <path d="M0,20 20,20 20,8 0,8z M10,13 10,16z M4,8 a6,8 0 0,1 12,0" />
                            </svg>
                            <input type="password" class="login__input pass" placeholder="Password" name="txt_password" />
                        </div>
                        <button type="button" class="login__submit">Sign in</button>
                    </form>
                </div>
            </div>
            <div class="app">
                <div class="app__top">
                    <p class="app__hello" id="keterangan">Selamat Datang</p>
                </div>
                <div class="app__logout">
                    <img src="<?php echo base_url('assets/login/arrow-back.png'); ?>" width="48px" />
                </div>
            </div>
        </div>
    </div>
    <script src="<?php echo base_url('assets/login'); ?>/jquery.min.js">
    </script>

    <script>
        $(document).ready(function() {
            var animating = false,
                submitPhase1 = 1100,
                submitPhase2 = 400,
                logoutPhase1 = 800,
                $login = $(".login"),
                $app = $(".app");

            function ripple(elem, e) {
                $(".ripple").remove();
                var elTop = elem.offset().top,
                    elLeft = elem.offset().left,
                    x = e.pageX - elLeft,
                    y = e.pageY - elTop;
                var $ripple = $("<div class='ripple'></div>");
                $ripple.css({
                    top: y,
                    left: x
                });
                elem.append($ripple);
            };

            $(document).on("click", ".login__submit", function(e) {
                if (animating)
                    return;
                animating = true;
                var that = this;
                ripple($(that), e);
                $(that).addClass("processing");

                var formData = $("#login_form").serializeArray();

                var formURL = $("#login_form").attr("action");

                $.ajax({
                    url: formURL,
                    type: "POST",
                    data: formData,
                    success: function(data, textStatus, jqXHR) {
                        console.log(data);
                        if (data !== 'OK') {
                            $('#keterangan').html(data);
                        } else {
                            window.location.replace("<?php echo site_url('admin'); ?>");
                        }
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        $('#keterangan').html('Opps, <br/>Maaf Terdapat kesalahan pada sistem, silahkan kembali beberapa saat');
                    }
                });

                setTimeout(function() {
                    $(that).addClass("success");
                    setTimeout(function() {
                        $app.show();
                        $app.css("top");
                        $app.addClass("active");
                    }, submitPhase2 - 70);
                    setTimeout(function() {
                        $login.hide();
                        $login.addClass("inactive");
                        animating = false;
                        $(that).removeClass("success processing");
                    }, submitPhase2);
                }, submitPhase1);
            });

            $(document).on("click", ".app__logout", function(e) {
                if (animating)
                    return;
                $(".ripple").remove();
                animating = true;
                var that = this;
                $(that).addClass("clicked");
                setTimeout(function() {
                    $app.removeClass("active");
                    $login.show();
                    $login.css("top");
                    $login.removeClass("inactive");
                }, logoutPhase1 - 120);
                setTimeout(function() {
                    $app.hide();
                    animating = false;
                    $(that).removeClass("clicked");
                }, logoutPhase1);
            });
        });
    </script>
</body>

</html>
