<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Cetak Hasil Ujian</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <style>
        body {
            font-family: Arial, 'Helvetica Neue', Helvetica, sans-serif;
            padding-top: 0px;
            font-size: 14px;
        }

        h1 {
            font-size: 16px;
            padding: 1px;
            text-align: center;
        }

        h3 {
            font-size: 14px;
            padding: 1px;
        }

        .hr {
            border-bottom: 1px solid #000;
            padding-top: 1px;
            padding-bottom: 2px;
        }

        table.gridtable {
            font-size: 14px;
            color: #333333;
            border-width: 1px;
            border-color: #666666;
            border-collapse: collapse;
            width: 100%;
            border-top: 1px solid #000;
            border-bottom: 1px solid #000;
        }

        table.gridtable th {
            border-width: 1px;
            padding: 4px;
            border-style: solid;
            border-color: #666666;
            background-color: #dedede;
        }

        table.gridtable tr {
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            border-bottom: 1px solid #000;
        }

        table.gridtable td {
            padding: 2px;
        }

        table.gridtable td.total {
            border: 1px solid #000;
            padding: 2px;
            font-weight: bold;
        }

        table.gridtable td.nototal {
            font-size: 14px;
            font-weight: bold;
            border: 0px;
            padding: 2px;
        }

        div.columns {
            column-width: 400px;
            -moz-column-width: 400px;
            -webkit-column-width: 400px;
        }

        div.keeptogether {
            display: inline-block;
            width: 100%;
        }
    </style>
</head>

<body>
    <h1>LAPORAN HASIL UJIAN PERKELAS</h1>
    <h1>MATA PELAJARAN <?php echo $detail->nama_mata_pelajaran; ?></h1>
    <hr />
    <table class="gridtable">
        <tr>
            <th>NO</th>
            <th>No Induk</th>
            <th>Nama Siswa/Peserta Ujian</th>
            <th>Kelas</th>
            <th>Waktu Pelaksanaan</th>
            <th>Paket Soal</th>
            <th>Jumlah Soal</th>
            <th>Skor</th>
        </tr>
        <?php
        if ($hasil) {
            $no = 0;
            foreach ($hasil as $h) {
                $no++;
                $jum_soal = $h->jumlah_soal;
                if ($jum_soal == 0) {
                    $jum_soal = 1;
                }
        ?>
                <tr>
                    <td><?php echo $no; ?></td>
                    <td><?php echo $h->no_induk; ?></td>
                    <td><?php echo $h->nama_lengkap; ?></td>
                    <td><?php echo $h->nama_kelas; ?></td>
                    <td><?php echo $h->mulai_ujian == NULL ? "Belum Melaksanakan Ujian" : date('d/m/Y H:i:s', strtotime($h->mulai_ujian)); ?></td>
                    <td><?php echo $h->deskripsi == NULL ? "Belum Melaksanakan Ujian" : $h->deskripsi; ?></td>
                    <td><?php echo $h->jumlah_soal == NULL ? "Belum Melaksanakan Ujian" : $h->jumlah_soal; ?></td>
                    <td><?php

                        if ($h->mulai_ujian == NULL) {
                            echo "Belum Melaksanakan Ujian";
                        } else {
                            $persen = $this->db->query("SELECT COALESCE(SUM(skor_ujian), 0) as jumlah from soal_ujian WHERE ujian_yang_dilaksanakan = '$h->id_ujian_dilaksanakan'")->row();

                            echo number_format($persen->jumlah, 2, ',', '.');
                        }
                        ?></td>
                </tr>
        <?php
            }
        }
        ?>
    </table>
</body>

</html>