<?php
defined('BASEPATH') || exit('No direct script access allowed');

if (!function_exists('waktu_yang_lalu')) {
    function waktu_yang_lalu($datetime) {
        $waktu_lalu = strtotime($datetime);
        $sekarang   = time();
        $selisih    = $sekarang - $waktu_lalu;

        if ($selisih < 60) {
            return 'baru saja';
        }

        $menit  = floor($selisih / 60);
        $jam    = floor($menit / 60);
        $hari   = floor($jam / 24);
        $minggu = floor($hari / 7);
        $bulan  = floor($hari / 30);
        $tahun  = floor($hari / 365);

        // TAHUN
        if ($tahun >= 1) {
            $sisa_bulan = floor(($hari % 365) / 30);
            return $tahun . ' tahun' . ($sisa_bulan > 0 ? ' ' . $sisa_bulan . ' bulan' : '') . ' yang lalu';
        }

        // BULAN
        if ($bulan >= 1) {
            $sisa_hari = $hari % 30;
            return $bulan . ' bulan' . ($sisa_hari > 0 ? ' ' . $sisa_hari . ' hari' : '') . ' yang lalu';
        }

        // MINGGU
        if ($minggu >= 1) {
            $sisa_hari = $hari % 7;
            return $minggu . ' minggu' . ($sisa_hari > 0 ? ' ' . $sisa_hari . ' hari' : '') . ' yang lalu';
        }

        // HARI
        if ($hari >= 1) {
            return $hari . ' hari yang lalu';
        }

        // JAM
        if ($jam >= 1) {
            return $jam . ' jam yang lalu';
        }

        // MENIT
        return $menit . ' menit yang lalu';
    }
}

if (!function_exists('status_waktu_class')) {
    function status_waktu_class($datetime) {
        $waktu_lalu = strtotime($datetime);
        $sekarang   = time();
        $selisih    = $sekarang - $waktu_lalu;

        $hari = floor($selisih / 86400); // 60*60*24

        if ($hari <= 1) {
            return 'alert-success'; // hijau
        }

        if ($hari <= 7) {
            return 'alert-warning'; // oranye
        }

        return 'alert-danger'; // merah
    }
}
